package module2

import org.apache.spark.rdd.RDD
import org.apache.spark.sql.functions.{col, lit}
import org.apache.spark.sql.{Dataset, Row, SparkSession}

class BasicOperations {

  def simpleRDD(): Unit ={
    val spark: SparkSession = SparkSession.builder()
      .appName("fundament-sparka")
      .master("local")
      .getOrCreate()

    val namesList: Seq[String] = Seq("marek", "kasia", "ignas", "jozio", "roza", "zygmunt", "arek", "julia")
    val namesRDD: RDD[String] = spark.sparkContext.parallelize(namesList)

    val namesBig: RDD[String] = namesRDD.map(n=> n.toUpperCase) // map - transformacja

    namesBig.take(5) // take - akcja
      .foreach(println)
  }

  def filterRDD(): Unit ={
    val spark: SparkSession = SparkSession.builder()
      .appName("fundament-sparka")
      .master("local")
      .getOrCreate()

    val namesList: Seq[String] = Seq("marek", "kasia", "ignas", "jozio", "roza", "zygmunt", "arek", "julia")
    val namesRDD: RDD[String] = spark.sparkContext.parallelize(namesList)

    val namesFiltered: RDD[String] = namesRDD.filter(n=>n.length <5) // map - transformacja

    namesFiltered.take(5) // take - akcja
      .foreach(println)
  }

  def sumRDD(): Unit ={
    val spark: SparkSession = SparkSession.builder()
      .appName("fundament-sparka")
      .master("local")
      .getOrCreate()

    val numbersList: Seq[Int] = Seq(10, 20, 30, 40, 50, 50)
    val numbersRDD: RDD[Int] = spark.sparkContext.parallelize(numbersList)

    val sum: Int = numbersRDD.reduce((v1, v2)=> v1 + v2) //reduce - akcja

    println(sum)
  }

  def readCSVDataFrame(): Unit ={
    val spark: SparkSession = SparkSession.builder()
      .appName("fundament-sparka")
      .master("local")
      .getOrCreate()

    val pizzaDF: Dataset[Row] = spark.read
      .option("header", "true")
      .csv("pizza_data.csv") // pełen adres lub sama nazzwa pliku, jeśli ten jest w folderze projektowym

    pizzaDF.show(false) // show - akcja
  }

  def filterDataFrame(): Unit ={
    val spark: SparkSession = SparkSession.builder()
      .appName("fundament-sparka")
      .master("local")
      .getOrCreate()

    val pizzaDF: Dataset[Row] = spark.read
      .option("header", "true")
      .csv("pizza_data.csv") // pełen adres lub sama nazzwa pliku, jeśli ten jest w folderze projektowym

    val pizzaWithFilterDF: Dataset[Row] = pizzaDF.filter(col("Type").contains(lit("Cheeses"))) //filter - transformacja

    val pizzaAmount: Long = pizzaWithFilterDF.count() //count = akcja
    println(s"Pizza amount: $pizzaAmount") // w tym momencie pizzaAmount to zwykły integer, który ląduje na driverze.
  }
}
